<?php

mysqli_report(MYSQLI_REPORT_OFF);
error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT);

/**
 * Application configuration
 */
$conf['settings']['app.title'] = 'Reservas GM';
$conf['settings']['default.timezone'] = 'America/Bogota';
$conf['settings']['allow.self.registration'] = 'false';

$conf['settings']['admin.email'] = 'soporte@sistemasgimnasiomoderno.net';
$conf['settings']['admin.email.name'] = 'Reservas GM';

$conf['settings']['company.name'] = 'Gimnasio Moderno';
$conf['settings']['company.url'] = 'https://sistemasgimnasiomoderno.net';

$conf['settings']['default.page.size'] = '50';

/**
 * Language / Email (apágalo hasta tener SMTP real)
 */
$conf['settings']['enable.email'] = 'false';
$conf['settings']['default.language'] = 'es';

/**
 * MUY IMPORTANTE: URL publica exacta a /Web
 * - HTTPS
 * - Web con W mayúscula
 * - sin slash final
 */
$conf['settings']['script.url'] = 'https://sistemasgimnasiomoderno.net/reservas/Web';

/**
 * Uploads
 */
$conf['settings']['image.upload.directory'] = 'Web/uploads/images';
$conf['settings']['image.upload.url'] = 'uploads/images';

/**
 * Performance
 */
$conf['settings']['cache.templates'] = 'true';
$conf['settings']['use.local.js.libs'] = 'false';

/**
 * Registration / Captcha
 */
$conf['settings']['registration.captcha.enabled'] = 'false';
$conf['settings']['registration.require.email.activation'] = 'false';
$conf['settings']['registration.auto.subscribe.email'] = 'false';
$conf['settings']['registration.notify.admin'] = 'false';

$conf['settings']['inactivity.timeout'] = '30';
$conf['settings']['name.format'] = '{first} {last}';
$conf['settings']['css.extension.file'] = '';
$conf['settings']['disable.password.reset'] = 'false';
$conf['settings']['home.url'] = '';
$conf['settings']['logout.url'] = '';
$conf['settings']['default.homepage'] = '1';

/**
 * Schedule
 */
$conf['settings']['schedule']['use.per.user.colors'] = 'false';
$conf['settings']['schedule']['show.inaccessible.resources'] = 'true';
$conf['settings']['schedule']['reservation.label'] = '{name}';
$conf['settings']['schedule']['hide.blocked.periods'] = 'false';
$conf['settings']['schedule']['update.highlight.minutes'] = '0';
$conf['settings']['schedule']['show.week.numbers'] = 'false';

/**
 * iCal integration
 */
$conf['settings']['ics']['subscription.key'] = '';
$conf['settings']['ics']['future.days'] = '30';
$conf['settings']['ics']['past.days'] = '0';

/**
 * Privacy
 */
$conf['settings']['privacy']['view.schedules'] = 'true';
$conf['settings']['privacy']['view.reservations'] = 'false';
$conf['settings']['privacy']['hide.user.details'] = 'false';
$conf['settings']['privacy']['hide.reservation.details'] = 'false';
$conf['settings']['privacy']['allow.guest.reservations'] = 'false';

/**
 * Reservation configuration
 */
$conf['settings']['reservation']['start.time.constraint'] = 'future';
$conf['settings']['reservation']['updates.require.approval'] = 'false';
$conf['settings']['reservation']['prevent.participation'] = 'false';
$conf['settings']['reservation']['prevent.recurrence'] = 'false';
$conf['settings']['reservation']['enable.reminders'] = 'false';
$conf['settings']['reservation']['allow.guest.participation'] = 'false';
$conf['settings']['reservation']['allow.wait.list'] = 'false';
$conf['settings']['reservation']['checkin.minutes.prior'] = '5';
$conf['settings']['reservation']['default.start.reminder'] = '';
$conf['settings']['reservation']['default.end.reminder'] = '';
$conf['settings']['reservation']['title.required'] = 'false';
$conf['settings']['reservation']['description.required'] = 'false';
$conf['settings']['reservation']['checkin.admin.only'] = 'false';
$conf['settings']['reservation']['checkout.admin.only'] = 'false';

/**
 * File upload configuration
 */
$conf['settings']['uploads']['enable.reservation.attachments'] = 'false';
$conf['settings']['uploads']['reservation.attachment.path'] = 'uploads/reservation';
$conf['settings']['uploads']['reservation.attachment.extensions'] = 'txt,jpg,gif,png,doc,docx,pdf,xls,xlsx,ppt,pptx,csv';

/**
 * Database configuration (tus datos)
 */
$conf['settings']['database']['type'] = 'mysql';
$conf['settings']['database']['user'] = 'sistemasgimnasio_reservas7';
$conf['settings']['database']['password'] = 'reservas7+77';
$conf['settings']['database']['hostspec'] = 'localhost';
$conf['settings']['database']['name'] = 'sistemasgimnasio_reservas7';

/**
 * Mail server configuration (preparado pero apagado globalmente)
 */
$conf['settings']['phpmailer']['mailer'] = 'smtp';
$conf['settings']['phpmailer']['smtp.host'] = '';
$conf['settings']['phpmailer']['smtp.port'] = '587';
$conf['settings']['phpmailer']['smtp.secure'] = 'tls';
$conf['settings']['phpmailer']['smtp.auth'] = 'false';
$conf['settings']['phpmailer']['smtp.username'] = '';
$conf['settings']['phpmailer']['smtp.password'] = '';
$conf['settings']['phpmailer']['sendmail.path'] = '/usr/sbin/sendmail';
$conf['settings']['phpmailer']['smtp.debug'] = 'false';

/**
 * Plugins
 */
$conf['settings']['plugins']['Authentication'] = '';
$conf['settings']['plugins']['Authorization'] = '';
$conf['settings']['plugins']['Permission'] = '';
$conf['settings']['plugins']['PostRegistration'] = '';
$conf['settings']['plugins']['PreReservation'] = '';
$conf['settings']['plugins']['PostReservation'] = '';

/**
 * Installation settings (NO uses la clave de la DB)
 */
$conf['settings']['install.password'] = 'GM-Install#2026!x9';

/**
 * Pages / API / Recaptcha / Reports
 */
$conf['settings']['pages']['enable.configuration'] = 'true';

$conf['settings']['api']['enabled'] = 'false';
$conf['settings']['api']['allow.self.registration'] = 'false';

$conf['settings']['recaptcha']['enabled'] = 'false';
$conf['settings']['recaptcha']['public.key'] = '';
$conf['settings']['recaptcha']['private.key'] = '';

$conf['settings']['email']['default.from.address'] = 'soporte@sistemasgimnasiomoderno.net';
$conf['settings']['email']['default.from.name'] = 'Reservas GM';

$conf['settings']['reports']['allow.all.users'] = 'false';

/**
 * Password rules
 */
$conf['settings']['password']['minimum.letters'] = '6';
$conf['settings']['password']['minimum.numbers'] = '0';
$conf['settings']['password']['upper.and.lower'] = 'false';

/**
 * Security headers
 */
$conf['settings']['security']['security.headers'] = 'false';
$conf['settings']['security']['security.strict-transport'] = 'true';
$conf['settings']['security']['security.x-frame'] = 'deny';
$conf['settings']['security']['security.x-xss'] = '1; mode=block';
$conf['settings']['security']['security.x-content-type'] = 'nosniff';
$conf['settings']['security']['security.content-security-policy'] = "";

/**
 * Logging (ruta válida en cPanel)
 * Crea esta carpeta y dale permisos 755:
 * /home/sistemasgimnasio/public_html/reservas/logs
 */
$conf['settings']['logging']['folder'] = '/home/sistemasgimnasio/public_html/reservas/logs';
$conf['settings']['logging']['level'] = 'error';
$conf['settings']['logging']['sql'] = 'false';

?>